function  commLabels = getCommunitiesHMM(obj)
%GETCOMMUNITIESHMM Find community structure of adjacency matrix using
%recursive application of the modularity maximization algorithm
%   [matrices] = GETCOMMUNITIESHMM(obj) will find the community structure
%      of AdjacencyMatrix obj using the function getCommunitiesMM, and
%      recursively apply modularity maximization to each community.  This
%      will attempt to avoid the resolution limit inherent in modularity
%      maximization.  This follows the suggestion of Ruan and Zhang in
%      Identifying network communities with a high resolution, 2008, though
%      it uses a different algorithm (the Newman-Leicht directed network
%      algorithm for modularity maximization).  The output matrices will be
%      a cell array, where each cell will itself be a cell array of
%      AdjacencyMatrix objects representing the sub-community structure

% Find the communities using modularity maximization, do not perform
% statistical test
[commLabels Q] = getCommunitiesMM(obj,'quiet');
initNumComms = numel(commLabels);
disp(initNumComms)
disp(Q)

nIters = 400;
minQ = .3;
minZ = 2;

for i = 1:initNumComms
    % Decompose communities into subcommunities if statistically
    % significant
    if numel(commLabels{i})>1
        try
            
            tmpMatrix = getSubMatrix(obj,commLabels{i});
            
        catch ME
%             move to next iteration; this is probably a singleton community
            continue
        end
        commLabels{i} = getCommunitiesMMsig(tmpMatrix,minQ,minZ,nIters);
    end
end


% initialize commLabs (these describe the tree structure)
% for i = 1:numel(comms), commLabs{i} = [i]; end

% Decompose communities 

% while true
%     
%     maximum = numel(comms);
%     fprintf('i: %u , max: %u, comms{8}: %s\n',i,maximum,class(comms{8}));
% 
%     if i>maximum, break; end
%     
%     [commsConsidered Q1] = getCommunitiesMM(comms{i},'quiet');
%     if Q1 > minq
%         z = getCommunitiesMMsig(comms{i},Q1,nIters);
%         if z>minz
%             comms = [comms commsConsidered];
%             for k = 1:numel(commsConsidered)
%                 commLabs{maximum+k} = [commLabs{i} k];
%                 fprintf('\nCommunity %u\n',commLabs{maximum+k}(:));
%             end
%         end
%     end
%     i = i+1;
% 
% end
% disp(commLabs)
% 
% matrices = {};
% % Display results
% for i = 1:initNumComms
%     depth = 1;
%     for j = 1:numel(commLabs)
%         if commLabs{j}(1) == i
%             depth = max(depth,length(commLabs{j}));
%         end
%     end
%     
%     for j = 1:numel(comms)
%         if length(commLabs{j}) == depth
%             matrices = [matrices comms{j}];
%             fprintf('\nCommunity %u\n',commLabs{j}(:));
%             fprintf('%s\n',comms{j}.cells.name);
%         end
%     end
end




